(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[5],{13:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.ALLOW_EMPTY_TARGET = undefined;\nexports.wpseoDeleteRedirect = wpseoDeleteRedirect;\nexports.wpseoRemoveNotification = wpseoRemoveNotification;\nexports.wpseoUndoRedirect = wpseoUndoRedirect;\nexports.wpseoCreateRedirect = wpseoCreateRedirect;\n\nvar _apiFetch = __webpack_require__(14);\n\nvar _apiFetch2 = _interopRequireDefault(_apiFetch);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nvar ALLOW_EMPTY_TARGET = exports.ALLOW_EMPTY_TARGET = [410, 451];\n\n/**\n * Deletes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type   The type of redirect.\n * @param {string} format The format of redirect.\n *\n * @returns {void}\n */\n/* global window, wpApiSettings, wpseoPremiumStrings, ajaxurl */\nfunction wpseoDeleteRedirect(origin, target, type) {\n\tvar format = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "plain";\n\n\treturn (0, _apiFetch2.default)({\n\t\tmethod: "POST",\n\t\turl: wpApiSettings.root + "yoast/v1/redirects/delete",\n\t\theaders: {\n\t\t\t"X-WP-Nonce": wpApiSettings.nonce\n\t\t},\n\t\tdata: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type,\n\t\t\tformat: format\n\t\t}\n\t});\n}\n\n/**\n * Removes a notification.\n *\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoRemoveNotification(source) {\n\tjQuery(source).closest(".yoast-notification").fadeOut("slow");\n}\n\n/**\n * Undoes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type The type of redirect.\n * @param {string} nonce The nonce being used to validate the current AJAX request.\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirect(origin, target, type, nonce, source) {\n\twpseoDeleteRedirect(origin, target, type).then(function (response) {\n\t\tif (response.success === true) {\n\t\t\twpseoRemoveNotification(source);\n\t\t}\n\t});\n}\n\n/**\n * Creates a redirect\n *\n * @param {string} origin The origin.\n * @param {string} type   The redirect type, regex or plain.\n * @param {string} nonce  The nonce.\n * @param {object} source The source of the redirect.\n *\n * @returns {void}\n */\nfunction wpseoCreateRedirect(origin, type, nonce, source) {\n\tvar target = "";\n\n\tif (parseInt(type, 10) !== 410) {\n\t\t/* eslint-disable no-alert */\n\t\ttarget = window.prompt(wpseoPremiumStrings.enter_new_url.replace("%s", origin));\n\t\t/* eslint-enable no-alert */\n\n\t\tif (target === "") {\n\t\t\t/* eslint-disable no-alert */\n\t\t\twindow.alert(wpseoPremiumStrings.error_new_url);\n\t\t\t/* eslint-enable no-alert */\n\t\t\treturn;\n\t\t}\n\t}\n\n\tjQuery.post(ajaxurl, {\n\t\taction: "wpseo_add_redirect_plain",\n\t\t/* eslint-disable-next-line camelcase */\n\t\tajax_nonce: nonce,\n\t\tredirect: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type\n\t\t}\n\t}, function (response) {\n\t\tvar notice = jQuery(source).closest(".yoast-notification");\n\t\t// Remove the classes first.\n\t\tjQuery(notice).removeClass("updated").removeClass("error");\n\n\t\t// Remove possibly added redirect errors.\n\t\tjQuery(notice).find(".redirect_error").remove();\n\n\t\tif (response.error) {\n\t\t\t// Add paragraph on top of the notice with actions and set class to error.\n\t\t\tjQuery(notice).addClass("error").prepend("<p class=\\"redirect_error\\">" + response.error.message + "</p>");\n\n\t\t\treturn;\n\t\t}\n\n\t\t// Parse the success message.\n\t\tvar successMessage = "";\n\t\tif (parseInt(type, 10) === 410) {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved_no_target;\n\t\t} else {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved.replace("%2$s", "<code>" + response.target + "</code>");\n\t\t}\n\n\t\tsuccessMessage = successMessage.replace("%1$s", "<code>" + response.origin + "</code>");\n\n\t\t// Set class to updated and replace html with the success message.\n\t\tjQuery(notice).addClass("updated").html("<p>" + successMessage + "</p>");\n\t}, "json");\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///13\n')},14:function(module,exports){eval("module.exports = window.wp.apiFetch;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTQuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cud3AuYXBpRmV0Y2hcIj9iYzBmIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LndwLmFwaUZldGNoOyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///14\n")},91:function(module,exports,__webpack_require__){"use strict";eval('\n\n/* global ajaxurl */\n/* jshint -W097 */\n\nvar redirectFunctions = __webpack_require__(13);\n\n/**\n * Use notification counter so we can count how many times the function wpseoShowNotification is called.\n *\n * @type {number}\n */\nvar wpseoNotificationCounter = 0;\n\n/**\n * Show notification to user when there\'s a redirect created. When the response is empty, up the notification counter\n * with 1, wait 100 ms and call function again.\n * Stop when the notification counter is bigger than 20.\n *\n * @returns {void}\n */\nfunction wpseoShowNotification() {\n\tjQuery.post(ajaxurl, { action: "yoast_get_notifications" }, function (response) {\n\t\tif (response !== "") {\n\t\t\tvar insertAfterElement = jQuery(".wrap").children().eq(0);\n\t\t\tjQuery(response).insertAfter(insertAfterElement);\n\t\t\twpseoNotificationCounter = 0;\n\t\t}\n\n\t\tif (wpseoNotificationCounter < 20 && response === "") {\n\t\t\twpseoNotificationCounter++;\n\t\t\tsetTimeout(wpseoShowNotification, 500);\n\t\t}\n\t});\n}\n\nwindow.wpseoShowNotification = wpseoShowNotification;\n\n/**\n * Gets the current page based on the current URL.\n *\n * @returns {string} The current page.\n */\nfunction wpseoGetCurrentPage() {\n\treturn jQuery(location).attr("pathname").split("/").pop();\n}\n\nwindow.wpseoGetCurrentPage = wpseoGetCurrentPage;\n\n/**\n * Gets the name of the field to get the slug from, based on the current URL.\n *\n * For posts, this is \'post_name\', for terms it is \'slug\'.\n *\n * @param {string} currentPage The current page.\n *\n * @returns {string} The current slug field name.\n */\nfunction wpseoGetSlugField(currentPage) {\n\tcurrentPage = currentPage || wpseoGetCurrentPage();\n\n\tif (currentPage === "edit-tags.php") {\n\t\treturn "slug";\n\t}\n\n\treturn "post_name";\n}\n\n/**\n * Gets the current slug of a post based on the current page and post or term being edited.\n *\n * @returns {string} The slug of the current post or term.\n */\nfunction wpseoGetCurrentSlug() {\n\tvar currentPost = wpseoGetItemId();\n\tvar slugField = wpseoGetSlugField();\n\n\treturn jQuery("#inline_" + currentPost).find("." + slugField).html();\n}\n\nwindow.wpseoGetCurrentSlug = wpseoGetCurrentSlug;\n\n/**\n * Checks whether or not the slug has changed.\n *\n * @returns {boolean} Whether or not the slug has changed.\n */\nfunction wpseoSlugChanged() {\n\tvar editor = wpseoGetActiveEditor();\n\tvar slugField = wpseoGetSlugField();\n\tvar currentSlug = wpseoGetCurrentSlug();\n\tvar newSlug = editor.find("input[name=" + slugField + "]").val();\n\n\treturn currentSlug !== newSlug;\n}\n\nwindow.wpseoSlugChanged = wpseoSlugChanged;\n\n/**\n * Gets the currently active editor used in quick edit.\n *\n * @returns {Object} The editor that is currently active.\n */\nfunction wpseoGetActiveEditor() {\n\treturn jQuery("tr.inline-editor");\n}\n\nwindow.wpseoGetActiveEditor = wpseoGetActiveEditor;\n\n/**\n * Gets the current post or term id.\n * Returns an empty string if no editor is currently active.\n *\n * @returns {string} The ID of the current post or term.\n */\nfunction wpseoGetItemId() {\n\tvar editor = wpseoGetActiveEditor();\n\n\tif (editor.length === 0 || editor === "") {\n\t\treturn "";\n\t}\n\n\treturn editor.attr("id").replace("edit-", "");\n}\n\nwindow.wpseoGetItemId = wpseoGetItemId;\n\n/**\n * Handles the key-based events in the quick edit editor.\n *\n * @param {Event} ev The event currently being executed.\n *\n * @returns {void}\n */\nfunction wpseoHandleKeyEvents(ev) {\n\t// 13 refers to the enter key.\n\tif (ev.which === 13 && wpseoSlugChanged()) {\n\t\twpseoShowNotification();\n\t}\n}\n\nwindow.wpseoHandleKeyEvents = wpseoHandleKeyEvents;\n\n/**\n * Handles the button-based events in the quick edit editor.\n *\n * @param {Event} ev The event currently being executed.\n *\n * @returns {void}\n */\nfunction wpseoHandleButtonEvents(ev) {\n\tif (jQuery(ev.target).attr("id") !== "save-order" && wpseoSlugChanged()) {\n\t\twpseoShowNotification();\n\t}\n}\n\nwindow.wpseoHandleButtonEvents = wpseoHandleButtonEvents;\n\nwindow.wpseoUndoRedirect = redirectFunctions.wpseoUndoRedirect;\nwindow.wpseoCreateRedirect = redirectFunctions.wpseoCreateRedirect;\nwindow.wpseoRemoveNotification = redirectFunctions.wpseoRemoveNotification;\n\njQuery(function () {\n\tvar wpseoCurrentPage = wpseoGetCurrentPage();\n\n\tif (["edit.php", "edit-tags.php"].includes(wpseoCurrentPage)) {\n\t\tjQuery("#inline-edit input").on("keydown", function (ev) {\n\t\t\twpseoHandleKeyEvents(ev);\n\t\t});\n\n\t\tjQuery(".button-primary").click(function (ev) {\n\t\t\twpseoHandleButtonEvents(ev);\n\t\t});\n\t}\n\n\tif (wpseoCurrentPage === "edit-tags.php") {\n\t\tjQuery(document).on("ajaxComplete", function (e, xhr, settings) {\n\t\t\tif (settings.data.indexOf("action=delete-tag") > -1) {\n\t\t\t\twpseoShowNotification();\n\t\t\t}\n\t\t});\n\t}\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///91\n')}},[[91,0]]]);